//*****************************************************
//                                              
// EmpDAO.java                  
//                                              
// This source code is generated by DB Cruiser. 
//                                              
// DB Cruiser is a product by:                  
// MathThinking Technologies, Inc.              
// http://www.maththinking.com                  
//                                              
//*****************************************************
import java.math.BigDecimal;
import java.sql.*;

public class EmpDAO
{
   public int getEmpno() {
      return this.empno;
   }

   public void setEmpno(int inValue) {
      empno = inValue;
   }

   public String getEname() {
      return this.ename;
   }

   public void setEname(String inValue) {
      ename = inValue;
   }

   public String getJob() {
      return this.job;
   }

   public void setJob(String inValue) {
      job = inValue;
   }

   public int getMgr() {
      return this.mgr;
   }

   public void setMgr(int inValue) {
      mgr = inValue;
   }

   public java.sql.Date getHiredate() {
      return this.hiredate;
   }

   public void setHiredate(java.sql.Date inValue) {
      hiredate = inValue;
   }

   public double getSal() {
      return this.sal;
   }

   public void setSal(double inValue) {
      sal = inValue;
   }

   public double getComm() {
      return this.comm;
   }

   public void setComm(double inValue) {
      comm = inValue;
   }

   public int getDeptno() {
      return this.deptno;
   }

   public void setDeptno(int inValue) {
      deptno = inValue;
   }

   public void setAttributes(ResultSet rs)
      throws SQLException {
      setEmpno(rs.getInt("EMPNO"));
      setEname(rs.getString("ENAME"));
      setJob(rs.getString("JOB"));
      setMgr(rs.getInt("MGR"));
      setHiredate(rs.getDate("HIREDATE"));
      setSal(rs.getDouble("SAL"));
      setComm(rs.getDouble("COMM"));
      setDeptno(rs.getInt("DEPTNO"));
   }

   public String statementOfInsert() {
      String str = "INSERT INTO EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) VALUES (?,?,?,?,?,?,?,?)";
      return str;
   }

   /**
    *  Please modify the WHERE condition to fit your case.
    */
   public String statementOfUpdate() {
      String str = "UPDATE EMP SET EMPNO = ?,ENAME = ?,JOB = ?,MGR = ?,HIREDATE = ?,SAL = ?,COMM = ?,DEPTNO = ? WHERE 1 > 1";
      return str;
   }

   public int insertDatabase(Connection conn)
      throws SQLException {
      PreparedStatement ps = null;
      try {
          ps = conn.prepareStatement(statementOfInsert());
          ps.setInt(1, getEmpno());
          ps.setString(2, getEname());
          ps.setString(3, getJob());
          ps.setInt(4, getMgr());
          ps.setDate(5, getHiredate());
          ps.setDouble(6, getSal());
          ps.setDouble(7, getComm());
          ps.setInt(8, getDeptno());
          return ps.executeUpdate();
      } finally {
          if (ps != null) {
              try {
                  ps.close();
                  ps = null;
              } catch(SQLException e) {}
          }
      }
   }

   public int updateDatabase(Connection conn)
      throws SQLException {
      PreparedStatement ps = null;
      try {
          ps = conn.prepareStatement(statementOfUpdate());
          ps.setInt(1, getEmpno());
          ps.setString(2, getEname());
          ps.setString(3, getJob());
          ps.setInt(4, getMgr());
          ps.setDate(5, getHiredate());
          ps.setDouble(6, getSal());
          ps.setDouble(7, getComm());
          ps.setInt(8, getDeptno());
          return ps.executeUpdate();
      } finally {
          if (ps != null) {
              try {
                  ps.close();
                  ps = null;
              } catch(SQLException e) {}
          }
      }
   }

   public String toString() {
      StringBuffer sb = new StringBuffer();
      sb.append("Empno = ["+getEmpno()+"]\n");
      sb.append("Ename = ["+getEname()+"]\n");
      sb.append("Job = ["+getJob()+"]\n");
      sb.append("Mgr = ["+getMgr()+"]\n");
      sb.append("Hiredate = ["+getHiredate()+"]\n");
      sb.append("Sal = ["+getSal()+"]\n");
      sb.append("Comm = ["+getComm()+"]\n");
      sb.append("Deptno = ["+getDeptno()+"]\n");
      return sb.toString();
   }

   private int empno;
   private String ename = null;
   private String job = null;
   private int mgr;
   private java.sql.Date hiredate = null;
   private double sal;
   private double comm;
   private int deptno;
}



